<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:p="http://www.sec.gov/edgar/ta/tatwofiler">

	<xsl:template name="item3_annualReportInfo">
	 <h1><xsl:value-of select="$submissionType"/>: Annual Report Information</h1>
	 <h3><center>If the response to any of questions 4-11 below is none or zero, enter "0."</center></h3>
		<table role="presentation">
			<tr>
				<td class="label">
					<b>4(a).</b> Number of items received for transfer during the reporting period:
				</td>
				<td>
					<div class="fakeBox2">	
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:numberItemsReceivedForTransfer)>0">
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:numberItemsReceivedForTransfer, "###,###")' />	
						</xsl:if>	
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>4(b).</b> Number of individual securityholder accounts for which the TA maintained master securityholder files:
				</td>
				<td>
					<div class="fakeBox2">	
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:numberMasterSecurityHolderFilings)>0">
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:numberMasterSecurityHolderFilings, "###,###")' />
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
			  <td class="label">
					<b>5(a).</b> Total number of individual securityholder accounts, including
					accounts in the Direct Registration System (DRS), dividend reinvestment
					plans and/or direct purchase plans as of December 31:
				</td>
				<td>
					<div class="fakeBox2">	
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:numberIndividualAccounts)>0">
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:numberIndividualAccounts, "###,###")' />
						</xsl:if>
					</div>
				</td>
			</tr>
	      <tr>
			  <td class="label">
					<b>5(b).</b> Number of individual securityholder dividend reinvestment plan
					and/or direct purchase plan accounts as of December 31:
				</td>
				<td>
					<div class="fakeBox2">		
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:numberDivReinvDirPurPlanAccounts)>0">
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:numberDivReinvDirPurPlanAccounts, "###,###")' />	
						</xsl:if>
					</div>
				</td>
			</tr>

	      <tr>
			  <td class="label">
					<b>5(c).</b> Number of individual securityholder DRS accounts as of December 31:
				</td>
				<td>
					<div class="fakeBox2">						
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:numberDirectRegistSystemAccounts)>0">
						<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:numberDirectRegistSystemAccounts, "###,###")' />	
						</xsl:if>
					</div>
				</td>
			</tr>
		</table>
		<p></p>
				<p>
					<b>5(d).</b> Approximate percentage of individual securityholder accounts from
					subsection (a) in the following categories as of December 31:
				</p>
	<table class="xdLayout" style="BORDER-RIGHT: medium none; TABLE-LAYOUT: fixed; BORDER-TOP: medium none; BORDER-LEFT: medium none; WIDTH: 970px; BORDER-BOTTOM: medium none; BORDER-COLLAPSE: collapse; WORD-WRAP: break-word" borderColor="buttontext" border="1">
			<colgroup>
				<col style="WIDTH: 163px"></col>
				<col style="WIDTH: 154px"></col>
				<col style="WIDTH: 200px"></col>
				<col style="WIDTH: 165px"></col>
				<col style="WIDTH: 154px"></col>
				<col style="WIDTH: 134px"></col>
			</colgroup>
		<tbody vAlign="top">
			<tr>
				<td class = "fakeBox5">
					<div align="center">						
						<b>5(d)(i). </b>
						<p></p>
						Corporate Equity
						<p></p>
						Securities						
					</div>
				</td>
				<td class = "fakeBox5">
					<div align="center">
						<b>5(d)(ii). </b>
						<p></p>
						Corporate Debt 
						<p></p>
						Securities															
					</div>
				</td>
				<td class = "fakeBox5">
					<div align="center">
						<b>5(d)(iii). </b>Open-End 
						<p></p>
						Investment Company 
						<p></p>
						Securities															
					</div>														
				</td>
				<td class = "fakeBox5">
					<div align="center">
						<b>5(d)(iv). </b>Limited 
						<p></p>
						Partnership 
						<p></p>
						Securities	
					</div>												
				</td>
				<td class = "fakeBox5">
					<div align="center">
					<b>5(d)(v). </b>
					<p></p>
					Municipal Debt
					<p></p>
					Securities															
					</div>
				</td>
				<td class = "fakeBox5">
					<div align="center">
						<b>5(d)(vi). </b>
						<p></p>
						Other 
						<p></p>
						Securities
					</div>	
				</td>
			</tr>
			<tr>				
				<td class = "fakeBox5">
					<div align= "right" class="h1a">									
						<xsl:value-of select="p:formData/p:serviceCompanyData/p:securityHolderAccounts/p:equitySecurity" />											
					</div>
				</td>
				<td class = "fakeBox5">
					<div align= "right" class="h1a">
						<xsl:value-of select="p:formData/p:serviceCompanyData/p:securityHolderAccounts/p:debtSecurity" />										
					</div>
				</td>
				<td class = "fakeBox5" >
					<div align= "right" class="h1a">	
						<xsl:value-of select="p:formData/p:serviceCompanyData/p:securityHolderAccounts/p:openEndInvestmentCompany" />			
					</div>				
				</td>
				<td class = "fakeBox5">
					<div align= "right" class="h1a">
						<xsl:value-of select="p:formData/p:serviceCompanyData/p:securityHolderAccounts/p:limitedPartnership" />		
					</div>
				</td>
				<td class = "fakeBox5">
					<div align= "right" class="h1a">
						<xsl:value-of select="p:formData/p:serviceCompanyData/p:securityHolderAccounts/p:municipalDebt" />	
					</div>
				</td>
				<td class = "fakeBox5" >
					<div align= "right" class="h1a">
						<xsl:value-of select="p:formData/p:serviceCompanyData/p:securityHolderAccounts/p:other" />																				
					</div>
				</td>				
			</tr>
		</tbody>
	</table>				
		
	<p></p>
    <b>6</b>.  Number of securities issues for which Registrant acted in the following capacities, as of December 31:
		<div>
			<table class="xdLayout" style="BORDER-RIGHT: medium none; TABLE-LAYOUT: fixed; BORDER-TOP: medium none; BORDER-LEFT: medium none; WIDTH: 970px; BORDER-BOTTOM: medium none; BORDER-COLLAPSE: collapse; WORD-WRAP: break-word" borderColor="buttontext" border="1">
				<colgroup>
					<col style="WIDTH: 256px"></col>
					<col style="WIDTH: 119px"></col>
					<col style="WIDTH: 119px"></col>
		    		<col style="WIDTH: 119px"></col>
					<col style="WIDTH: 119px"></col>
					<col style="WIDTH: 119px"></col>
					<col style="WIDTH: 119px"></col>
				</colgroup>
				<tbody vAlign="top">
					<tr style="MIN-HEIGHT: 19px">
						<td rowSpan="2" class = "fakeBox5">
							<div align="center"> </div>
						</td>													
						<td colSpan="2" class = "fakeBox5">
							<div align="center">
								Corporate Securities
							</div>
						</td>
						<td rowSpan="2" class = "fakeBox5">
							<div align="center">
								Open-End Investment Company Securities
							</div>
						</td>
						<td rowSpan="2" class = "fakeBox5">
							<div align="center">
								Limited Partnership Securities
							</div>
						</td>
						<td rowSpan="2" class = "fakeBox5">
							<div align="center">
								Municipal Debt Securities
							</div>
						</td>
						<td rowSpan="2" class = "fakeBox5">
							<div align="center">
								<p></p>
								<p></p>
								Other Securities
							</div>
						</td>
					</tr>
					<tr style="MIN-HEIGHT: 5px">
						<td class = "fakeBox5">
							<div align="center">
								Equity
							</div>
						</td>
						<td class = "fakeBox5">
							<div align="center">
								Debt
							</div>
						</td>
					</tr>			
					<tr style="MIN-HEIGHT: 19px">						
						<td class = "fakeBox5">
							<div>
								<b>6(a). </b>Receives items for transfer and maintains the master securityholder files:
							</div>
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(a)(i).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:equitySecurity)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:equitySecurity, "###,###")' />
								</xsl:if>
							</div>														
						</td>													
						<td class = "fakeBox6">
							<div align="center">
								<b>6(a)(ii).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:debtSecurity)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:debtSecurity, "###,###")' />
								</xsl:if>
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(a)(iii).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:openEndInvestmentCompany)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:openEndInvestmentCompany, "###,###")' />
								</xsl:if>
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(a)(iv).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:limitedPartnership)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:limitedPartnership, "###,###")' />
								</xsl:if>							
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(a)(v).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:municipalDebt)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:municipalDebt, "###,###")' />
								</xsl:if>
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(a)(vi).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:other)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transMaintainMasterSecHolder/p:other, "###,###")' />
								</xsl:if>
							</div>														
						</td>													
					</tr>
					<tr style="MIN-HEIGHT: 15px">						
						<td class = "fakeBox5">
							<div>
								<b>6(b). </b>Receives items for transfer but does not maintain the master securityholder files:
							</div>
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(b)(i).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:equitySecurity)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:equitySecurity, "###,###")' />
								</xsl:if>
							</div>														
						</td>													
						<td class = "fakeBox6">
							<div align="center">
								<b>6(b)(ii).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:debtSecurity)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:debtSecurity, "###,###")' />
								</xsl:if>
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(b)(iii).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:openEndInvestmentCompany)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:openEndInvestmentCompany, "###,###")' />
								</xsl:if>
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(b)(iv).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:limitedPartnership)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:limitedPartnership, "###,###")' />
								</xsl:if>
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(b)(v).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:municipalDebt)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:municipalDebt, "###,###")' />
								</xsl:if>
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(b)(vi).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:other)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:transNotMaintMasterSecHolder/p:other, "###,###")' />
								</xsl:if>
							</div>														
						</td>													
					</tr>
					<tr style="MIN-HEIGHT: 16px">						
						<td class = "fakeBox5">
							<div>
								<b>6(c). </b>Does not receive items for transfer but maintains the master securityholder files:
							</div>
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(c)(i).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:equitySecurity)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:equitySecurity, "###,###")' />
								</xsl:if>
							</div>														
						</td>													
						<td class = "fakeBox6">
							<div align="center">
								<b>6(c)(ii).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:debtSecurity)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:debtSecurity, "###,###")' />
								</xsl:if>	
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(c)(iii).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:openEndInvestmentCompany)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:openEndInvestmentCompany, "###,###")' />
								</xsl:if>
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(c)(iv).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:limitedPartnership)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:limitedPartnership, "###,###")' />
								</xsl:if>								
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(c)(v).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:municipalDebt)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:municipalDebt, "###,###")' />
								</xsl:if>
							</div>														
						</td>
						<td class = "fakeBox6">
							<div align="center">
								<b>6(c)(vi).</b>																				
							</div>
							<div align="center"> </div>
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:other)>0">
									<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:notTransMaintMasterSecHolder/p:other, "###,###")' />
								</xsl:if>
							</div>														
						</td>													
					</tr>
				</tbody>
			</table>
		</div>				
		<p></p>
		<b>7</b>. Scope of certain additional types of activities performed:     	
		<table>	
			<tr>
				<td class="label">
					<b>7(a).</b> Number of issues for which dividend reinvestment plan and/or direct
					purchase plan services were provided, as of December 31:
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:dividendReinvDirectPurchasePlan)>0">
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:dividendReinvDirectPurchasePlan, "###,###")' />
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>7(b).</b> Number of issues for which DRS services were provided, as of December 31:
				</td>
				<td>
					<div class="fakeBox2">	
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:directRegistrationSystem)>0">
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:directRegistrationSystem, "###,###")' />	
						</xsl:if>		
					</div>
				</td>
			</tr>
		</table>
		
		<p>
			<b>7(c).</b> Dividend disbursement and interest paying agent activities conducted during the reporting period:	
		</p>
		
		<table role="presentation">
			<tr>
				<td class="label">
					<b>7(c)(i).</b> number of issues
				</td>
				<td>					
					<div class="fakeBox2">
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:dividendAndInterest/p:numberIssues)>0">
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:dividendAndInterest/p:numberIssues, "###,###")' />
						</xsl:if>	
					</div>					
				</td>

				<td class="label">
					<b>7(c)(ii).</b> amount (in dollars)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:dividendAndInterest/p:amountIssues)>0">
							<font color= "black">$ </font>	
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:dividendAndInterest/p:amountIssues, "###,###.##")' />
						</xsl:if>
					</div>								
				</td>
			</tr>
		</table>		
	<p>
		<b>8(a). </b>
		Number and aggregate market value of securities aged record
		differences, existing for more than 30 days, as of December 31:
	</p>	
  	<div>					
		<table class="xdLayout" style="BORDER-RIGHT: medium none; TABLE-LAYOUT: fixed; BORDER-TOP: medium none; BORDER-LEFT: medium none; WIDTH: 618px; BORDER-BOTTOM: medium none; BORDER-COLLAPSE: collapse; WORD-WRAP: break-word" borderColor="buttontext" border="1" >
			<colgroup>							
				<col style="WIDTH: 250px"></col>
				<col style="WIDTH: 184px"></col>
				<col style="WIDTH: 184px"></col>
			</colgroup>
			<tbody vAlign="top">
				<tr>
					<td class="fakeBox5">
						<div> </div>
					</td>
					<td class="fakeBox5">
						<div align="center">
							Prior Transfer Agent(s)
							<p></p>
							(If applicable)
						</div>										
					</td>
					<td class="fakeBox5">
						<div align="center">
							Current Transfer Agent
						</div>									
					</td>
				</tr>
				<tr style="MIN-HEIGHT: 20px">
					<td class="fakeBox5">
						<div align="left">
							<b>8(a)(i). </b>Number of issues:							
						</div>									
					</td>
					<td class="fakeBox5">
						<div align="right" class="h1a">
							<xsl:if
								test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:priorAgent/p:numberIssues)>0">
								<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:priorAgent/p:numberIssues, "###,###.##")' />	
							</xsl:if>	
						</div>
					</td>
					<td class="fakeBox5">
						<div align="right" class="h1a">
							<xsl:if
								test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:currentAgent/p:numberIssues)>0">
								<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:currentAgent/p:numberIssues, "###,###.##")' />
							</xsl:if>				
						</div>
					</td>
				</tr>
				<tr style="MIN-HEIGHT: 25px">
					<td class="fakeBox5">						
						<div align="left">							
								<b>8(a)(ii). </b>Market value (in dollars):						
						</div>									
					</td>
					<td class="fakeBox5">
						<div  align="right" class="h1a">
							<xsl:if
								test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:priorAgent/p:amountIssues)>0">											
								<font color= "black">$ </font>	
								<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:priorAgent/p:amountIssues, "###,###.##")' />						
							</xsl:if>			
						</div>
					</td>
					<td class="fakeBox5">
						<div align="right" class="h1a">
							<xsl:if
								test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:currentAgent/p:amountIssues)>0">
								<font color= "black">$ </font>
								<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:currentAgent/p:amountIssues, "###,###.##")' />
							</xsl:if>			
						</div>
					</td>
				</tr>
			</tbody>
		</table>
	</div>	
	<p></p>
     <table role="presentation">	
			<tr>
				<td
					class="label">
					<b>8(b).</b> Number of quarterly reports regarding buy-ins filed by the registrant
					with its ARA (including the SEC) during the reporting period pursuant
					to Rule 17Ad-11(c)(2):
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:numberFiled)>0">
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:numberFiled, "###,###")' />
						</xsl:if>
					</div>
				</td>
			</tr>
	</table>
   <p></p>
	<table role="presentation">	
			<tr>
				<td
					class="label">
					<b>8(c).</b> During the reporting period, did the Registrant file all quarterly
					reports regarding buy-ins with its ARA (including the SEC) required by
					Rule 17Ad-11(c)(2)?
				</td>
				<td>
					
					<xsl:choose>
						<xsl:when
							test="contains(p:formData/p:serviceCompanyData/p:securityHolderData/p:fileAll , 'Yes')">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Yes
					<xsl:choose>
						<xsl:when
							test="contains(p:formData/p:serviceCompanyData/p:securityHolderData/p:fileAll , 'No')
							and not(contains(p:formData/p:serviceCompanyData/p:securityHolderData/p:fileAll , 'Applicable'))">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					No
					<xsl:choose>
						<xsl:when
							test="contains(p:formData/p:serviceCompanyData/p:securityHolderData/p:fileAll , 'Not Applicable')">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Not Applicable
				</td>
			</tr>
			<xsl:if test="p:formData/p:serviceCompanyData/p:securityHolderData/p:fileAll = 'No'">
			<tr>
				<td
					class="label">
					<b>8(d).</b> If the answer to subsection (c) is no, provide an explanation for each failure to file:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of
							select="p:formData/p:serviceCompanyData/p:securityHolderData/p:additionalInformation" />
					</div>
				</td>
			</tr>			
			</xsl:if>
		</table>
		<p></p>
		<table role="presentation">	
			<tr>
				<td
					class="label">
					<b>9(a).</b> During the reporting period has the Registrant always been in
					compliance with the turnaround time for routine items as set forth in
					Rule 17Ad-2?
				</td>
				<td>					
					<xsl:choose>
						<xsl:when
							test="contains(p:formData/p:serviceCompanyData/p:securityHolderData/p:alwaysCompliant , 'Yes')">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Yes
					<xsl:choose>
						<xsl:when
							test="contains(p:formData/p:serviceCompanyData/p:securityHolderData/p:alwaysCompliant , 'No')
							and not(contains(p:formData/p:serviceCompanyData/p:securityHolderData/p:alwaysCompliant , 'Applicable'))">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					No
					<xsl:choose>
						<xsl:when
							test="contains(p:formData/p:serviceCompanyData/p:securityHolderData/p:alwaysCompliant , 'Not Applicable')">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Not Applicable
				</td>
			</tr>
		</table>
      <p></p>
		<h3><center>If the answer to subsection (a) is no, complete subsections (i) through (ii)</center></h3>

      <table role="presentation">
			<xsl:if 
				test="p:formData/p:serviceCompanyData/p:securityHolderData/p:alwaysCompliant = 'No'">
			<tr>
				<td
					class="label">
						<b>9(a)(i).</b> Provide the number of months during the reporting period in
						which the Registrant was not in compliance with the turnaround time for
						routine items as set forth in Rule 17Ad-2
				</td>
				<td>
					<div class="fakeBox2">
							<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:numberMonthsNotCompliant)>0">
							<xsl:value-of select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:numberMonthsNotCompliant, "###,###")' />
							</xsl:if>	
					</div>
				</td>
			</tr>			
			<tr>
				<td
					class="label">
					<b>9(a)(ii).</b> Provide the number of written notices registrant filed during the reporting 
					period with the SEC and with its ARA that reported its noncompliance with turnaround 
					time for routine items according to Rule 17Ad-2
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if
							test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:numberNoticeNonComplianceFiled)>0">
							<xsl:value-of
								select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:numberNoticeNonComplianceFiled, "###,###")' />
						</xsl:if>
					</div>
				</td>
			</tr>				
			</xsl:if>
		</table>		
		<p></p>
			<b>10.</b> Number of open-end investment company securities purchases and
			redemptions (transactions) excluding dividend, interest and
			distribution postings, and address changes processed during the
			reporting period:
		<table role="presentation">	
			<tr>
				<td
					class="label">
						<b>10(a).</b> Total number of transactions processed:
				</td>
				<td>
					<div class="fakeBox2">
							<xsl:if
								test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:total)>0">
								<xsl:value-of
									select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:total, "###,###")' />
							</xsl:if>
					</div>
				</td>			
			</tr>
			<tr>
				<td
					class="label">
						<b>10(b).</b> Number of transactions processed on a date other than date of receipt of order (as ofs):
				</td>
				<td>
					<div class="fakeBox2">
							<xsl:if
								test="string-length(p:formData/p:serviceCompanyData/p:securityHolderData/p:totalOtherThanReceiptOrderDate)>0">
								<xsl:value-of
									select='format-number(p:formData/p:serviceCompanyData/p:securityHolderData/p:totalOtherThanReceiptOrderDate, "###,###")' />
							</xsl:if>
					</div>
				</td>			
			</tr>			
		</table>		
	<p></p>
		<b>11(a).</b>
		During the reporting period, provide the date of all database searches
		conducted for lost securityholder accounts listed on the transfer
		agent's master securityholder files, the number of lost securityholder
		accounts for which a database search has been conducted, and the
		number of lost securityholder accounts for which a different address
		has been obtained as a result of a database search:
	<p></p>	
	<div>	
		<xsl:for-each select="p:formData/p:serviceCompanyData/p:databaseSearches">
			<table class="xdRepeatingTable msoUcTable" title="" style="TABLE-LAYOUT: fixed; WIDTH: 696px; BORDER-TOP-STYLE: none; BORDER-RIGHT-STYLE: none; BORDER-LEFT-STYLE: none; BORDER-COLLAPSE: collapse; WORD-WRAP: break-word; BORDER-BOTTOM-STYLE: none" border="1" >
				<colgroup>
					<col style="WIDTH: 150px"></col>
					<col style="WIDTH: 320px"></col>
					<col style="WIDTH: 300px"></col>
				</colgroup>
				<tbody class="xdTableHeader">
					<tr>
						<td class="fakeBox5">
							<b>11(a)(i). </b>Date of Database Search						
						</td>
						<td class="fakeBox5">
							<b>11(a)(ii). </b>Number of Lost Securityholder Accounts Submitted for Database Search																	
						</td>
						<td class="fakeBox5">
							<div align="center">
							<b>11(a)(iii). </b>Addresses Obtained from Database Search
							</div>
						</td>
					</tr>
				</tbody>
				<tbody>						
					<tr>
						<td class="fakeBox5">
							<div align="center" class="h1a"> 
								<xsl:if
									test="string-length(p:databaseSearchDate)>0">				
									<xsl:value-of select="p:databaseSearchDate" />
								</xsl:if>
							</div>
						</td>
						<td class="fakeBox5">
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:numberLostAccountsSearched)>0">											
									<xsl:value-of select='format-number(p:numberLostAccountsSearched, "###,###")' />											
								</xsl:if>
							</div>
						</td>
						<td class="fakeBox5">
							<div align="center" class="h1a">
								<xsl:if
									test="string-length(p:numberAddressesFromSearch)>0">										
									<xsl:value-of select='format-number(p:numberAddressesFromSearch, "###,###")'/>										
								</xsl:if>
							</div>
						</td>
					</tr>					
				</tbody>
			</table>
		</xsl:for-each>	
	</div>	
	<p></p>
	<table role="presentation">	
		<tr>
			<td
				class="label">
					<b>11(b).</b> Number of lost securityholder accounts that have been remitted to the states during the reporting period:
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:if
						test="string-length(p:formData/p:serviceCompanyData/p:numberLostAccountsRemittedToStates)>0">
						<xsl:value-of
							select='format-number(p:formData/p:serviceCompanyData/p:numberLostAccountsRemittedToStates, "###,###")' />
					</xsl:if>
				</div>
			</td>			
		</tr>
	</table>	
	
	</xsl:template>	
	
</xsl:stylesheet>